/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ui.tests.dialogs;

/**
 * FOR USE BY TESTS ONLY!
 * <p>
 * Stub class that provides access to classes visible to the package
 * <code>org.eclipse.ui.wizards.datatransfer</code>.  For the purpose
 * of testing.
 * </p>
 * @private
 */
public class DataTransferTestStub {
    //Prevent instantiation
    private DataTransferTestStub() {
    }

    /**
     * Gives access to an instance of WizardFileSystemResourceExportPage1.
     * @return IWizardPage an instance of WizardFileSystemResourceExportPage1
     */
    /**
     * 1GJWD2E: ITPUI:ALL - Test classes should not be released in public packages.
     *
     public static IWizardPage newFileSystemResourceExportPage1(IStructuredSelection selection) {
     return new WizardFileSystemResourceExportPage1(selection);
     }
     */
    /**
     * Gives access to an instance of WizardFileSystemResourceImportPage1.
     * @return IWizardPage an instance of WizardFileSystemResourceImportPage1
     */
    /**
     * 1GJWD2E: ITPUI:ALL - Test classes should not be released in public packages.
     *
     public static IWizardPage newFileSystemResourceImportPage1(IWorkbench workbench, IStructuredSelection selection) {
     return new WizardFileSystemResourceImportPage1(workbench, selection);
     }
     */
    /**
     * Gives access to an instance of WizardZipFileResourceExportPage1.
     * @return IWizardPage an instance of WizardZipFileResourceExportPage1
     */
    /**
     * 1GJWD2E: ITPUI:ALL - Test classes should not be released in public packages.
     *
     public static IWizardPage newZipFileResourceExportPage1(IStructuredSelection selection) {
     return new WizardZipFileResourceExportPage1(selection);
     }
     */
    /**
     * Gives access to an instance of WizardZipFileResourceImportPage1.
     * @return IWizardPage an instance of WizardZipFileResourceImportPage1
     */
    /**
     * 1GJWD2E: ITPUI:ALL - Test classes should not be released in public packages.
     *
     public static IWizardPage newZipFileResourceImportPage1(IStructuredSelection selection) {
     return new WizardZipFileResourceExportPage1(selection);
     }
     */
}

